// ConfigureTimeZoneRange.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ConfigureTimeZoneRange.h"
#include <comdef.h>
#include<atlbase.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigureTimeZoneRange dialog


CConfigureTimeZoneRange::CConfigureTimeZoneRange(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigureTimeZoneRange::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigureTimeZoneRange)
	m_StopTime = _T("");
	m_BeginTime = _T("");
	m_DayType = 0;
	//}}AFX_DATA_INIT
}

CConfigureTimeZoneRange ::CConfigureTimeZoneRange(IApplication *pApp):CDialog(CConfigureTimeZoneRange::IDD, NULL)
{
	pApplication = pApp;
	pTZ.CreateInstance(__uuidof(TimeZone));
	
}


void CConfigureTimeZoneRange::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigureTimeZoneRange)
	DDX_Control(pDX, IDC_TZLIST_TZ, m_TZList);
	DDX_Control(pDX, IDC_ACCTLIST_TZ, m_AcctList);
	DDX_Text(pDX, IDC_STOPTIME, m_StopTime);
	DDX_Text(pDX, IDC_BEGINTIME, m_BeginTime);
	DDX_Text(pDX, IDC_DTYPE, m_DayType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigureTimeZoneRange, CDialog)
	//{{AFX_MSG_MAP(CConfigureTimeZoneRange)
	ON_BN_CLICKED(IDC_CHECK, OnConfigure)
	ON_CBN_SELCHANGE(IDC_ACCTLIST_TZ, OnSelchangeAcctList)
	ON_CBN_SELCHANGE(IDC_TZLIST_TZ, OnSelchangeTZList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigureTimeZoneRange message handlers

BOOL CConfigureTimeZoneRange::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_StopTime = _T("");
	m_BeginTime = _T("");
	m_DayType = 0;
	UpdateData(FALSE);
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigureTimeZoneRange::OnConfigure() 
{
	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	if(index<0)
		return;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);
	
	int index_TZ = m_TZList.GetCurSel();
	CString sTZID;
	if(index<0)
		return;
	m_TZList.GetLBText(index_TZ,sTZID);
	long lTZID = _wtoi(sTZID);

	UpdateData(TRUE);
	BSTR bstrStartTime;
	BSTR bstrEndTime;

	
	long lStatus;
	long lCount = 0;
	VARIANT vTimeZoneRanges;
	
	ITimeZoneRange *pITZ = NULL;

	COleSafeArray saTZRanges;
	saTZRanges.CreateOneDim(VT_DISPATCH,1);
	
	
	ITimeZoneRangePtr	pTZR;
	pTZR.CreateInstance(__uuidof(TimeZone));

	bstrStartTime = m_BeginTime.AllocSysString();
	bstrEndTime = m_StopTime.AllocSysString();
	pTZR->StartTime = bstrStartTime;
	pTZR->EndTime = bstrEndTime;
	pTZR->DayType = m_DayType;
	pTZR->TZID = lTZID;//m_TimeZoneID;
//			pTZR->AccountID = 1;//m_AcctID
		
	HRESULT hr = pTZR->QueryInterface(IID_ITimeZoneRange, (void**)&pITZ);
	if(SUCCEEDED(hr)) //timezone query interface succeeds if start
	{
		saTZRanges.PutElement(&lCount,pITZ);
	}

	vTimeZoneRanges=saTZRanges.Detach();

	
	pApplication->ConfigureTimeZoneRange(lAcctID,lTZID,vTimeZoneRanges,&lStatus);	
	//pApplication->GetTimeZoneRangesByTZID(119,&vTZRanges);
	//pApplication->DeleteTimeZoneRange(119,1388,&lStatus);
	
	if (lStatus == 105)
	{
		AfxMessageBox(L"InValid Account");
		return;
	}
	if(lStatus == 605)
	{
		AfxMessageBox(L"Invalid Time zone");
	}
	if(lStatus == 607)
	{
		AfxMessageBox(L"Invalid Time zone Range");
	}
	if(lStatus == 608)
	{
		AfxMessageBox(L"Invalid DayType");
	}
	if(lStatus == 604)
	{
		AfxMessageBox(L"System Timezone range cannot be edited");
	}
	if(lStatus ==0)
	{
		AfxMessageBox(L"Time Zone Range Configuration succeeded");
		CDialog::OnOK();
	}
	if(lStatus ==1)
	{
		AfxMessageBox(L"Time Zone Range Configuration failed");
	}
}

void CConfigureTimeZoneRange :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sID;
				sID.Format(_T("%ld"),pAccount->AccountID);
				m_AcctList.AddString(sID);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CConfigureTimeZoneRange ::LoadTimezones()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID, sAcctName;
		m_AcctList.GetLBText(index,sAcctID);
		BSTR bstrAcctName = sAcctID.AllocSysString();
		long lAcctID = _wtoi(sAcctID);
		_variant_t vAccounts;
		vAccounts.Clear();

		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, i = 0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				if(lAcctID == pAccount->AccountID)
				{
					sAcctName = (LPCSTR) pAccount->AccountName;
					break;
				}
			}
			pDisp->Release();
		}

		bstrAcctName = sAcctName.AllocSysString();
		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetTimeZonesByAccountName(bstrAcctName,&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			AfxMessageBox(_T("No Timezones"));
			return;
		}
		
		uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray saTZ(vTZs);
		saTZ.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			saTZ.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_TZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_TZList.SetCurSel(0);
}

void CConfigureTimeZoneRange::OnSelchangeAcctList() 
{
	m_TZList.ResetContent();
	LoadTimezones();
}

void CConfigureTimeZoneRange::OnSelchangeTZList() 
{
	// Do Something
}
